/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware;

import jace.Emulator;
import jace.config.ConfigurableField;
import jace.config.Name;
import jace.core.Card;
import jace.core.Motherboard;
import jace.core.RAMEvent;
import jace.core.Utility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

@Name(value="RamFactor")
public class CardRamFactor
extends Card {
    int ADDR1 = 0;
    int ADDR2 = 1;
    int ADDR3 = 2;
    int DATA = 3;
    int BANK_SELECT = 15;
    @ConfigurableField(category="memory", name="Ram size", description="Size of card ram in KB", shortName="size", defaultValue="8192")
    public int RAM_SIZE = 8192;
    int actualSize = this.RAM_SIZE * 1024;
    int addressPointer = 0xFFFFFF;
    int firmwareBank = 0;
    Card theCard = this;
    @ConfigurableField(category="performance", name="Speed Boost", description="Boost emulator speed when RAM in use", shortName="boostSpeed", defaultValue="false")
    public boolean speedBoost = false;
    ImageIcon indicator;
    byte[] cardRam;
    int ADDRESS_MASK = 0x7FFFFF;
    final int cxRomLength = 8192;
    byte[] romData = new byte[8192];

    @Override
    public String getDeviceName() {
        return "RamFactor";
    }

    public CardRamFactor() {
        this.indicator = Utility.loadIcon("ram.png");
        try {
            this.loadRom("jace/data/RAMFactor14.rom");
        }
        catch (IOException ex) {
            Logger.getLogger(CardRamFactor.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.allocateMemory(this.actualSize);
        this.updateFirmwareMemory();
    }

    @Override
    public void reset() {
        this.firmwareBank = 0;
        this.updateFirmwareMemory();
    }

    @Override
    public void reconfigure() {
        this.actualSize = this.RAM_SIZE * 1024;
        this.allocateMemory(this.actualSize);
        this.updateFirmwareMemory();
    }

    @Override
    protected void handleIOAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        Emulator.getFrame().addIndicator(this, this.indicator);
        value &= 0xFF;
        switch (register) {
            case 0: 
            case 4: {
                if (type.isRead()) {
                    e.setNewValue(this.addressPointer & 0xFF);
                    break;
                }
                this.addressPointer = this.addressPointer & 0xFFFF00 | value;
                if (this.RAM_SIZE > 1024) break;
                this.addressPointer |= 0xF00000;
                break;
            }
            case 1: 
            case 5: {
                if (type.isRead()) {
                    e.setNewValue(this.addressPointer >> 8 & 0xFF);
                    break;
                }
                this.addressPointer = this.addressPointer & 0xFF00FF | value << 8;
                if (this.RAM_SIZE > 1024) break;
                this.addressPointer |= 0xF00000;
                break;
            }
            case 2: 
            case 6: {
                if (type.isRead()) {
                    if (this.RAM_SIZE <= 1024) {
                        e.setNewValue(0xF0 | this.addressPointer >> 16 & 0xFF);
                        break;
                    }
                    e.setNewValue(this.addressPointer >> 16 & 0xFF);
                    break;
                }
                this.addressPointer = this.addressPointer & 0xFFFF | value << 16;
                if (this.RAM_SIZE > 1024) break;
                this.addressPointer |= 0xF00000;
                break;
            }
            case 3: 
            case 7: {
                if (type.isRead()) {
                    e.setNewValue(this.readMemory(this.addressPointer));
                } else {
                    this.writeMemory(this.addressPointer, (byte)value);
                }
                ++this.addressPointer;
                this.addressPointer &= 0xFFFFFF;
                break;
            }
            case 15: {
                if (type == RAMEvent.TYPE.WRITE) {
                    this.firmwareBank = value;
                    this.updateFirmwareMemory();
                }
            }
            default: {
                if (!type.isRead()) break;
                e.setNewValue(255);
            }
        }
    }

    @Override
    protected void handleFirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        if (this.speedBoost) {
            Motherboard.requestSpeed(this);
        }
    }

    @Override
    public void tick() {
    }

    @Override
    protected void handleC8FirmwareAccess(int register, RAMEvent.TYPE type, int value, RAMEvent e) {
        if (this.speedBoost) {
            Motherboard.requestSpeed(this);
        }
    }

    private byte readMemory(int i) {
        while (i >= this.cardRam.length) {
            i -= this.cardRam.length;
        }
        return this.cardRam[i];
    }

    private void writeMemory(int i, byte newValue) {
        while (i >= this.cardRam.length) {
            i -= this.cardRam.length;
        }
        this.cardRam[i] = newValue;
    }

    private void allocateMemory(int size) {
        if (this.cardRam != null && this.cardRam.length == size) {
            return;
        }
        this.cardRam = new byte[size];
        Arrays.fill(this.cardRam, (byte)0);
    }

    @Override
    public void setSlot(int slot) {
        super.setSlot(slot);
        this.indicator.setDescription("Slot " + this.getSlot());
        this.updateFirmwareMemory();
    }

    public void loadRom(String path) throws IOException {
        InputStream romFile = CardRamFactor.class.getClassLoader().getResourceAsStream(path);
        if (romFile.read(this.romData) != 8192) {
            throw new IOException("Bad RamFactor rom size");
        }
        this.updateFirmwareMemory();
    }

    private void updateFirmwareMemory() {
        int romOffset = 0;
        if ((this.firmwareBank & 1) == 1) {
            romOffset = 4096;
        }
        this.getCxRom().loadData(this.romData, romOffset + this.getSlot() * 256, 256);
        this.getC8Rom().loadData(this.romData, romOffset + 2048, 2048);
    }
}

